<?php

/**
 * Forever Wedding - Counter Down Section
 * 
 * This template is use by js composer plugin 
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
add_action('vc_before_init', 'foreverwedding_counter_down');

function foreverwedding_counter_down() {
    vc_map(array(
        "name" => esc_html__("Foreverwedding Counter Down section", 'foreverwedding'),
        "base" => "foreverwedding_counter_down",
        "class" => "",
        "icon" => get_template_directory_uri() . "/assets/admin/vc-icon.png",
        "category" => esc_html__('Forever Wedding', "foreverwedding"),
        "params" => array(
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Year Field", 'foreverwedding'),
                "param_name" => "year",
                "value" => '',
                "description" => esc_html__("Enter full year here like = 2016 ", 'foreverwedding')
            ),
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Month Field", 'foreverwedding'),
                "param_name" => "month",
                "value" => '',
                "description" => esc_html__("Enter month here like = 9 for September", 'foreverwedding')
            ),
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Day Field", 'foreverwedding'),
                "param_name" => "day",
                "value" => '',
                "description" => esc_html__("Enter day here like = 10", 'foreverwedding')
            ),
        )
    ));
}

class WPBakeryShortCode_foreverwedding_counter_down extends WPBakeryShortCode { }
