<?php

/**
 * Forever Wedding - Activities Section
 * 
 * This template is use by js composer plugin 
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
add_action('vc_before_init', 'foreverwedding_activities');

function foreverwedding_activities() {
    vc_map(array(
        "name" => esc_html__("Forever Wedding Activities", 'foreverwedding'),
        "base" => "foreverwedding_activities",
        "class" => "",
        "icon" => get_template_directory_uri() . "/assets/admin/vc-icon.png",
        "category" => esc_html__('Forever Wedding', "foreverwedding"),
        "params" => array(
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section Title", 'foreverwedding'),
                "param_name" => "title",
                "value" => '',
                "description" => esc_html__("Enter section title", 'foreverwedding')
            ),
             array(
                "type" => "textarea",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Activities Content", 'foreverwedding'),
                "param_name" => "activities_content",
                "value" => '',
                "description" => esc_html__("Enter Activities Content Here.", 'foreverwedding')
            ),
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section sub Title", 'foreverwedding'),
                "param_name" => "recreational_section",
                "value" => '',
                "description" => esc_html__("Enter section sub title", 'foreverwedding')
            ),
             array(
                "type" => "param_group",
                "class" => "",
                "heading" => esc_html__("Section Repeater", "foreverwedding"),
                "param_name" => "recreational_section_repeater",
                "description" => esc_html__("Section Repeater", "foreverwedding"),
                'params' => array(
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter button link',
                        'param_name' => 'recreational_btn_link',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter button label',
                        'param_name' => 'recreational_btn_page',
                    ),
                ),
            ),
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section sub Title", 'foreverwedding'),
                "param_name" => "sightseeing_section",
                "value" => '',
                "description" => esc_html__("Enter section sub title", 'foreverwedding')
            ),
            array(
                "type" => "param_group",
                "class" => "",
                "heading" => esc_html__("Section Repeater", "foreverwedding"),
                "param_name" => "sightseeing_section_repeater",
                "description" => esc_html__("Section Repeater", "foreverwedding"),
                'params' => array(
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter button link',
                        'param_name' => 'sightseeing_btn_link',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter button label',
                        'param_name' => 'sightseeing_btn_page',
                    ),
                ),
            ),
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section sub Title", 'foreverwedding'),
                "param_name" => "shopping_section",
                "value" => '',
                "description" => esc_html__("Enter section sub title", 'foreverwedding')
            ),
            array(
                "type" => "param_group",
                "class" => "",
                "heading" => esc_html__("Section Repeater", "foreverwedding"),
                "param_name" => "shopping_section_repeater",
                "description" => esc_html__("Section Repeater", "foreverwedding"),
                'params' => array(
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter button link',
                        'param_name' => 'shopping_btn_link',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter button label',
                        'param_name' => 'shopping_btn_page',
                    ),
                ),
            ),
        )
    ));
}

class WPBakeryShortCode_foreverwedding_activities extends WPBakeryShortCode { }
