<?php
/**
 * Forever Wedding - wedding info 
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'title' => '',
    'wedding_info_section_repeater' => '',
		), $atts));
?>
<!-- about us section start here -->
<div class="event-page">
    <section class="event-content-section">
	<div class="container">
	    <div class="row">
		<?php if (!empty($title)): ?>
    		<div class="header-center">								
    		    <h2><?php echo esc_html($title); ?></h2>										
    		</div>
		<?php endif; ?>
	    </div>
	    <?php
	    $wedding_info_section_repeater = vc_param_group_parse_atts($atts['wedding_info_section_repeater']);
	    if (!empty($wedding_info_section_repeater) && is_array($wedding_info_section_repeater)):
		$count = 1;
		foreach ($wedding_info_section_repeater as $info_section_repeater):
		    if ($count % 2 == 0) {
			?>

	    	    <div class="row margin-top">
	    		<div class="col-xs-12 col-sm-6">

	    		    <div class="right-part">
				    <?php
				    if (isset($info_section_repeater['wedding_img'])):
					$wedding_img = wp_get_attachment_url($info_section_repeater['wedding_img']);
					if (!empty($wedding_img)) {
					    ?> 
		    			<figure>  <img src="<?php echo apply_filters('foreverwedding_image_resize', esc_url($wedding_img), '570', '481'); ?>" alt="<?php echo esc_attr(get_the_title($info_section_repeater['wedding_img'])); ?>" title="" /></figure>
					    <?php
					}
				    endif;
				    ?> 
	    		    </div>
	    		</div>			
	    		<div class="col-xs-12 col-sm-6">

	    		    <div class="left-part">
	    			<div class="left-part-header">
					<?php
					if (isset($info_section_repeater['wedding_title'])):
					    $wedding_title = $info_section_repeater['wedding_title'];
					    if (!empty($wedding_title)) {
						?> 
		    			    <h3><a href="#"><?php echo esc_html($wedding_title); ?></a></h3>
					    <?php } endif; ?> 
	    			</div>
				    <?php if (isset($info_section_repeater['wedding_content'])): ?>
					<p><?php echo wp_kses($info_section_repeater['wedding_content'], wp_kses_allowed_html('post')); ?></p>
				    <?php endif; ?> 
	    			<div class="left-inner-header">
					<?php
					if (isset($info_section_repeater['wedding_sub_title'])):
					    $wedding_sub_title = $info_section_repeater['wedding_sub_title'];
					    if (!empty($wedding_sub_title)) {
						?> 
		    			    <h4><?php echo esc_html($wedding_sub_title); ?></h4>
					    <?php } endif; ?> 
	    			</div>
				    <?php if (isset($info_section_repeater['wedding_sub_content'])): ?>
					<p><?php echo wp_kses($info_section_repeater['wedding_sub_content'], wp_kses_allowed_html('post')); ?></p>
				    <?php endif; ?> 
				    <?php if (isset($info_section_repeater['wedding_features'])): ?>
					<div> <?php echo wp_kses($info_section_repeater['wedding_features'], wp_kses_allowed_html('post')); ?>   </div>                                  
				    <?php endif; ?> 
	    		    </div>
	    		</div>
	    	    </div>
			<?php
		    }
		    else {
			?>
	    	    <div class="row margin-top">
	    		<div class="col-xs-12 col-sm-6 wedding-info-img">
	    		    <div class="right-part">
				    <?php
				    if (isset($info_section_repeater['wedding_img'])):
					$wedding_img = wp_get_attachment_url($info_section_repeater['wedding_img']);
					if (!empty($wedding_img)) {
					    ?> 
		    			<figure>  <img src="<?php echo apply_filters('foreverwedding_image_resize', esc_url($wedding_img), '570', '481'); ?>" alt="<?php echo esc_attr(get_the_title($info_section_repeater['wedding_img'])); ?>" title="" /></figure>
					    <?php
					}
				    endif;
				    ?> 
	    		    </div>
	    		</div>
	    		<div class="col-xs-12 col-sm-6">
	    		    <div class="left-part">
	    			<div class="left-part-header">
					<?php
					if (isset($info_section_repeater['wedding_title'])):
					    $wedding_title = $info_section_repeater['wedding_title'];
					    if (!empty($wedding_title)) {
						?> 
		    			    <h3><a href="#"><?php echo esc_html($wedding_title); ?></a></h3>
					    <?php } endif; ?> 
	    			</div>
				    <?php if (isset($info_section_repeater['wedding_content'])): ?>
					<p><?php echo wp_kses($info_section_repeater['wedding_content'], wp_kses_allowed_html('post')); ?></p>
				    <?php endif; ?> 
	    			<div class="left-inner-header">
					<?php
					if (isset($info_section_repeater['wedding_sub_title'])):
					    $wedding_sub_title = $info_section_repeater['wedding_sub_title'];
					    if (!empty($wedding_sub_title)) {
						?> 
		    			    <h4><?php echo esc_html($wedding_sub_title); ?></h4>
					    <?php } endif; ?> 
	    			</div>
				    <?php if (isset($info_section_repeater['wedding_sub_content'])): ?>
					<p><?php echo wp_kses($info_section_repeater['wedding_sub_content'], wp_kses_allowed_html('post')); ?></p>
				    <?php endif; ?> 
				    <?php if (isset($info_section_repeater['wedding_features'])): ?>
					<div> <?php echo wp_kses($info_section_repeater['wedding_features'], wp_kses_allowed_html('post')); ?>   </div>                                  
				    <?php endif; ?> 
	    		    </div>
	    		</div>
	    	    </div>
			<?php
		    }
		    $count++;
		endforeach;
	    endif;
	    ?>
	</div>
    </section>
</div>
<!-- about us section end here -->
<?php
echo ($this->endBlockComment('foreverwedding_wedding_info'));
