<?php
/**
 * Forever Wedding - Portfolio
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'title' => '',
                ), $atts));

$terms = get_terms('gallery_category', array(
    'hide_empty' => true,
        ));
?>
<section class="gallery-part">
    <?php if (!empty($title)): ?>
        <div class="header-center">
            <h2><?php echo esc_html($title); ?></h2>
        </div><?php endif; ?>
    <div class="tabbing-wrapper">
        <button title="Tooltip on left" data-placement="left" data-toggle="tooltip" class="btn btn-default" data-filter="all" type="button">
            <?php esc_html_e('ALL', 'foreverwedding'); ?>
        </button>
        <?php if (!empty($terms) && count($terms) > 0): foreach ($terms as $term) : ?>
                <button title="Tooltip on top" data-placement="top" data-toggle="tooltip" class="btn btn-default" data-filter="<?php echo esc_attr($term->slug); ?>" type="button">
                    <?php echo esc_html($term->name); ?>
                </button>
            <?php endforeach;
        endif; ?>	
    </div>
    <?php
    $per_page = 4;
    $args = array(
        'post_type' => 'gallery',
        'post_status' => 'publish',
        'order' => 'ASC',
        'posts_per_page' => $per_page
    );

    $total_posts = wp_count_posts('gallery')->publish;

    $galleries = get_posts($args);
    
    if (count($galleries) > 0):
        ?>
        <div class="gallery-blog">
            <ul class="gallery-img-sec clearfix">
                <?php
                foreach ($galleries as $gallery):
                    $terms_gallery = get_the_terms($gallery->ID, 'gallery_category');
                    $gallery_classes = "";
                    if (!empty($terms_gallery) && count($terms_gallery) > 0):
                        foreach ($terms_gallery as $term_gallery):
                            $gallery_classes = " " . $term_gallery->slug;
                        endforeach;
                    endif;
                    
                    $gallery_thumb = wp_get_attachment_url(get_post_thumbnail_id($gallery->ID), 'full');
                    if (!empty($gallery_thumb)):
                        ?>
                        <li class="main-item all<?php echo esc_attr($gallery_classes); ?>">
                            <a  class="fancybox-button" data-fancybox-group="fancybox-button" href="<?php echo esc_url($gallery_thumb); ?>" title="<?php echo esc_attr($gallery->post_title); ?>">  
                                <img src="<?php echo esc_url($gallery_thumb); ?>" alt="<?php echo esc_attr($gallery->post_title); ?>" title="<?php echo esc_attr($gallery->post_title); ?>"/>
                            </a>
                        </li>
                        <?php
                    endif;
                endforeach;
                ?>
            </ul>
           		
        </div>
     <div class="load-more dd">
                <a href="javascript: void(0);" data-listedposts="<?php echo esc_attr($per_page); ?>" data-totalposts="<?php echo esc_attr($total_posts); ?>" class="btn btn-default"><?php esc_html_e('LOAD MORE', 'foreverwedding'); ?></a>
            </div>
    <?php endif; ?>
</section>
<?php
echo ($this->endBlockComment('foreverwedding_portfolio'));
