<?php
/**
 * Forever Wedding - Inner Brand Ticker Section
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'inner_title' => '',
    'sec_bg_color' => '',
    'inner_brand_ticker_section_repeater' => '',
		), $atts));
?>
<div class="home-agency">
    <section class="wedding-gift" style="background-color:<?php echo esc_attr($sec_bg_color); ?>">
	<div class="container">
	    <div class="row">
		<div class="info-wrap">
		    <?php if (!empty($inner_title)): ?>
    		    <h2><?php echo esc_html($inner_title); ?></h2>
		    <?php endif; ?>
		</div>
	    </div>
	</div>
	<div class="wedding-section-gift partner-sec">
	    <div class="container">
		<div class="partner-slider" dir="ltr">
		    <?php
		    $inner_brand_ticker_section_repeater = vc_param_group_parse_atts($atts['inner_brand_ticker_section_repeater']);
		    if (!empty($inner_brand_ticker_section_repeater) && is_array($inner_brand_ticker_section_repeater)):
			foreach ($inner_brand_ticker_section_repeater as $inner_ticker_section_repeater):
			    ?>	
			    <div class="item">
				<div class="gift-class">
				    <?php
				    if (isset($inner_ticker_section_repeater['inner_brand_ticker_image'])):
					$inner_brand_ticker_image = wp_get_attachment_url($inner_ticker_section_repeater['inner_brand_ticker_image']);
					if (!empty($inner_brand_ticker_image)) {
					    ?> 
					    <img src="<?php echo apply_filters('foreverwedding_image_resize', esc_url($inner_brand_ticker_image), '129', '104'); ?>" alt="<?php echo esc_attr($inner_ticker_section_repeater['inner_brand_ticker_image']); ?>" title="<?php echo esc_attr($inner_ticker_section_repeater['inner_brand_ticker_image']); ?>" />
					    <?php
					}
				    endif;
				    ?> 	
				</div>
			    </div>
			    <?php
			endforeach;
		    endif;
		    ?>
		</div>
	    </div>
	</div>

    </section>
</div>
<?php
echo ($this->endBlockComment('foreverwedding_inner_brand_ticker'));
