<?php
/**
 * Forever Wedding - important people
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'title' => '',
    'important_people_section_repeater' => '',
		), $atts));
?>
<section class="important-people">
    <div class="container">
	<div class="row">
	    <?php if (!empty($title)): ?>
    	    <div class="header-center">
    		<h2><?php echo esc_html($title); ?></h2>
    	    </div><?php endif; ?>
	</div>
    </div>
    <div class="img-section clearfix">
	<div class="container">
	    <div class="row">
		<div class="people" dir="ltr">
		    <?php
		    $important_people_section_repeater = vc_param_group_parse_atts($atts['important_people_section_repeater']);
		    if (!empty($important_people_section_repeater) && is_array($important_people_section_repeater)):
			foreach ($important_people_section_repeater as $people_section_repeater):
			    ?>	
			    <div class="item">
				<div class="img">
				    <?php
				    if (isset($people_section_repeater['people_image'])):
					$people_image = wp_get_attachment_url($people_section_repeater['people_image']);
					if (!empty($people_image)) {
					    ?> 
					    <img src="<?php echo apply_filters('foreverwedding_image_resize', esc_url($people_image), '270', '312'); ?>" alt="<?php echo esc_attr($people_section_repeater['people_image']); ?>" title="<?php echo esc_attr($people_section_repeater['people_image']); ?>" />
					    <?php
					}
				    endif;
				    ?> 	
				    <?php
				    if (isset($people_section_repeater['people_title'])):
					$people_title = $people_section_repeater['people_title'];
					if (!empty($people_title)) {
					    ?> 
					    <span class="overlay"> <span><?php echo esc_html($people_title); ?></span> </span>
					<?php } endif; ?> 
				</div>
			    </div>
			    <?php
			endforeach;
		    endif;
		    ?>
		</div>
	    </div>
	</div>
    </div>

</section>
<?php
echo ($this->endBlockComment('foreverwedding_important_people'));
