<?php
/**
 * Forever Wedding - Activities Section
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'title' => '',
    'activities_content' => '',
    'recreational_section' => '',
    'recreational_section_repeater' => '',
    'sightseeing_section' => '',
    'sightseeing_section_repeater' => '',
    'shopping_section' => '',
    'shopping_section_repeater' => '',
		), $atts));
?>

<div class="travel-page">
    <section class="activites">
	<div class="container">
	    <div class="row">
		<div class="header-center-content">
		    <?php if (!empty($title)): ?>
    		    <h2><?php echo esc_html($title); ?></h2>
		    <?php endif; ?>
		    <?php if (!empty($activities_content)): ?>
    		    <p><?php echo esc_html($activities_content); ?></p>
		    <?php endif; ?>
		</div>
	    </div>
	    <div class="row">
		<div class="col-xs-12 col-sm-4">
		    <div class="left-inner-header">
			<?php if (!empty($recreational_section)): ?>
    			<h4><?php echo esc_html($recreational_section); ?></h4>
			<?php endif; ?>
			<?php
			$recreational_section_repeater = vc_param_group_parse_atts($atts['recreational_section_repeater']);
			if (!empty($recreational_section_repeater) && is_array($recreational_section_repeater)):
			    foreach ($recreational_section_repeater as $recreation_section_repeater):
				if (isset($recreation_section_repeater['recreational_btn_page'])):
				    $recreational_btn_page = $recreation_section_repeater['recreational_btn_page'];
				    if (!empty($recreational_btn_page)) {
					?> 
					<a class="park-class" href="<?php echo esc_url($recreation_section_repeater['recreational_btn_link']); ?>"><?php echo esc_html($recreational_btn_page); ?></a>
					<?php
				    } endif;
			    endforeach;
			endif;
			?>	
		    </div>
		</div>
		<div class="col-xs-12 col-sm-4">
		    <div class="left-inner-header">
			<?php if (!empty($sightseeing_section)): ?>
    			<h4><?php echo esc_html($sightseeing_section); ?></h4>
			<?php endif; ?>
			<?php
			$sightseeing_section_repeater = vc_param_group_parse_atts($atts['sightseeing_section_repeater']);
			if (!empty($sightseeing_section_repeater) && is_array($sightseeing_section_repeater)):
			    foreach ($sightseeing_section_repeater as $sight_section_repeater):
				if (isset($sight_section_repeater['sightseeing_btn_page'])):
				    $sightseeing_btn_page = $sight_section_repeater['sightseeing_btn_page'];
				    if (!empty($sightseeing_btn_page)) {
					?> 
					<a class="park-class" href="<?php echo esc_url($sight_section_repeater['sightseeing_btn_link']); ?>"><?php echo esc_html($sightseeing_btn_page); ?></a>
					<?php
				    } endif;
			    endforeach;
			endif;
			?>	
		    </div>
		</div>
		<div class="col-xs-12 col-sm-4">
		    <div class="left-inner-header">
			<?php if (!empty($shopping_section)): ?>
    			<h4><?php echo esc_html($shopping_section); ?></h4>
			<?php endif; ?>
			<?php
			$shopping_section_repeater = vc_param_group_parse_atts($atts['shopping_section_repeater']);
			if (!empty($shopping_section_repeater) && is_array($shopping_section_repeater)):
			    foreach ($shopping_section_repeater as $shop_section_repeater):
				if (isset($shop_section_repeater['shopping_btn_page'])):
				    $shopping_btn_page = $shop_section_repeater['shopping_btn_page'];
				    if (!empty($shopping_btn_page)) {
					?> 
					<a class="park-class" href="<?php echo esc_url($shop_section_repeater['shopping_btn_link']); ?>"><?php echo esc_html($shopping_btn_page); ?></a>
					<?php
				    } endif;
			    endforeach;
			endif;
			?>	
		    </div>
		</div>
	    </div>
	</div>
    </section>
</div>
<?php
echo ($this->endBlockComment('foreverwedding_activities'));
