<?php
/**
 * 
 * ForeverWedding - Page Default Template
 * 
 * @package foreverwedding
 * @version 1.0.0
 * 
 */
get_header();
?>
<!--banner Section start-->
<?php do_action('foreverwedding_blog_banner', get_the_title()); ?>
<!--banner Section End-->
<div id="content" class="post-content blog main-blog">
    <div class="container">
        <div class="col-xs-12 col-sm-12 col-md-12">
            <?php
            if (have_posts()) :
                while (have_posts()) : the_post();
                    ?>
                    <div <?php post_class('row'); ?>>
                        <article class="blog-post-wrapper padding">
                            <?php
                            $foreverwedding_url = wp_get_attachment_url(get_post_thumbnail_id());
                            if (esc_url($foreverwedding_url)):
                                ?>
                                <figure>  
                                    <img src="<?php echo apply_filters('foreverwedding_image_resize', $foreverwedding_url, '870', '408'); ?>" alt="<?php the_title(); ?>" title="<?php the_title(); ?>">
                                </figure>
                            <?php endif; ?>
                            <div class="post-blog blog-single-quotes">
                                <h2> <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                <?php the_content(); ?>
                            </div>
                        </article>
                    </div>
                    <?php
                endwhile;
                if ('off' != ot_get_option('page_comment_on_off')):
                    if (comments_open() || get_comments_number()) :
                        get_template_part('content/post', 'author');
                        comments_template();
                    endif;
                endif;
            else :
                get_template_part('content/none');
            endif;
            ?>
        </div>
    </div>
</div>
<?php
get_footer();
