<?php

/**
 * Forever Wedding - Theme Options
 *
 * @package foreverwedding
 * @subpackage foreverwedding.inc.options.field
 * @since foreverwedding 1.0
 */
add_filter("ot_theme_options_sections", "foreverwedding_options_section");

function foreverwedding_options_section($sections) {
    $sections = include trailingslashit( get_template_directory() ).'/inc/options/options-section.php';
    return $sections;
}

add_filter("ot_theme_options_settings", 'foreverwedding_options_settings');

function foreverwedding_options_settings($settings = array()) {

    $options = array(
        "general",
        "typography",
        "google-font",
        "site",
        "contact",
        "social",
        "social-share",
        "projects",
        "404",
        "coming-soon",
        "advance",
        "footer",
    );

    foreach ($options as $option) {
        $args = include trailingslashit( get_template_directory() ).'/inc/options/field/' . $option . '.php';
        foreach ($args as $arg) {
            $settings[] = $arg;
        }
    }
    return $settings;
  
}
