<?php 
/**
 * ForeverWedding - Wedding Event metabox
 *
 * @package foreverwedding
 * @subpackage foreverwedding/inc/metabox
 * @version 1.0.0
 */
class ForeverWedding_Event_Meta {

    public function __construct() {
        $this->action();
    }

    function action() {
        add_filter("foreverwedding_post_register", array(&$this, "eventMeta"));
    }

    /**
     * Forever Wedding Metabox
     * @param type $args
     * @return string
     */
    function eventMeta($args) {
        $args[] = array(
            'id' => 'event_boxes',
            'title' => esc_html__('Wedding Event', 'foreverwedding'),
            'desc' => '',
            'pages' => array('event'),
            'context' => 'normal',
            'priority' => 'high',
            'fields' => array(
				array(
                    'id' => 'ceremony_date',
                    'label' => esc_html__('Enter Ceremony Date', 'foreverwedding'),
                    'desc' => esc_html__('Enter Ceremony Date.', 'foreverwedding'),
                    'type' => 'textarea',
                    'class' => '',
                ),
                array(
                    'id' => 'ceremony_address',
                    'label' => esc_html__('Enter Ceremony Address', 'foreverwedding'),
                    'desc' => esc_html__('Enter Ceremony Address.', 'foreverwedding'),
                    'type' => 'textarea',
                    'class' => '',
                ),               
            )
        );
        return $args;
    }

}

new ForeverWedding_Event_Meta();
