<?php

/**
 * Forever Wedding - core functionality
 * 
 * @package foreverwedding
 * @since foreverwedding 1.0.0
 */
/**
 * Forever Wedding - define constant
 * @since foreverwedding 1.0.0
 */
define('FOREVERWEDDING_THEME_DIR', get_template_directory());
define('FOREVERWEDDING_THEME_URL', get_template_directory_uri());

/**
 * Forever Wedding - Theme Setup  functinality
 * @version 1.0.0
 */
require_once( trailingslashit( get_template_directory() ).'/inc/theme-setup.php');


/**
 * Forever Wedding -Enqueue scripts & styles in assets 
 * @version 1.0.0
 */
require_once( trailingslashit( get_template_directory() ).'/inc/assets.php');

/**
 * Forever Wedding - general-layout, blog-layout  
 * @version 1.0.0
 */
require_once( trailingslashit( get_template_directory() ).'/inc/general-layout.php');
require_once( trailingslashit( get_template_directory() ).'/inc/blog-layout.php');
require_once( trailingslashit( get_template_directory() ).'/inc/helper-function.php');

/**
 * Forever Wedding - vendor reponsible for demodata import & theme option
 * @version 1.0.0
 */
require_once( trailingslashit( get_template_directory() ).'/vendor/vendor.php');


/**
 * Forever Wedding - pagination & image resize 
 * @version 1.0.0
 */
require_once( trailingslashit( get_template_directory() ).'/inc/lib/pagination.php');
require_once( trailingslashit( get_template_directory() ).'/inc/lib/image-resize.php');

/**
 * Forever Wedding - metabox, login-form, plugin-support, widgets & comment 
 * @version 1.0.0
 */
require_once( trailingslashit( get_template_directory() ).'/inc/metabox/metabox.php');
require_once( trailingslashit( get_template_directory() ).'/inc/plugins-support.php');
require_once( trailingslashit( get_template_directory() ).'/inc/widgets/widgets.php');
require_once( trailingslashit( get_template_directory() ).'/inc/comment.php');

/**
 * Forever Wedding - post-load 
 * @version 1.0.0
 */
require_once( trailingslashit( get_template_directory() ).'/inc/post-load.php');

/**
 * Forever Wedding - Visual Composer
 * @since foreverwedding 1.0.0
 */
if (defined('WPB_VC_VERSION')) {
    require_once( trailingslashit( get_template_directory() ).'/vc_templates/vc-map/vc-map.php');
}