<?php
/**
 * ForeverWedding - comming soon layout
 * 
 * @package foreverwedding
 * @subpackage foreverwedding/content
 * @version 1.0.0
 */
?>
<!DOCTYPE html>
<html lang="en" class="under-construction">
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta http-equiv='X-UA-Compatible' content='IE=edge' />
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
        <link rel="profile" href="http://gmpg.org/xfn/11">
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
        <?php wp_head(); ?>
    </head>
    <body  <?php body_class(); ?>>
        <div id="wrapper">
            <section class="coming-soon">
                <?php
                $foreverwedding_coming_soon_bg_color = ot_get_option('coming_soon_background_color');
                if (empty($foreverwedding_coming_soon_bg_color)):
                    $foreverwedding_coming_soon_bg_color = '#e08e79';
                endif;
                ?>
                <div id="particles-js" style="background-color:<?php echo esc_attr($foreverwedding_coming_soon_bg_color); ?>"></div>
                <div class="container">
                    <?php
                    wp_enqueue_script('foreverwedding-particle');
                    wp_enqueue_script('foreverwedding-particle-app');
                    ?>
                    <div class="row">
                        <div class="col-sm-12 text-center">
                            <div class="home-wrapper">
                                <?php
                                $foreverwedding_title = ot_get_option('coming_soon_title');
                                if (!empty($foreverwedding_title)):
                                    ?>
                                    <h1 class="home-text big-font white"><span class="rotate"><?php echo esc_html($foreverwedding_title); ?></span></h1>
                                <?php
                                endif;
                                $foreverwedding_content = ot_get_option('coming_soon_description');
                                if (!empty($foreverwedding_content)):
                                    ?>
                                    <p class="m-t-30 white"><?php echo wp_kses_post($foreverwedding_content); ?></p>
<?php endif; ?>
                                <!-- COUNTDOWN -->
                                <div class="row space-30">
                                    <div class="col-sm-12">
                                        <div class="row">
                                            <div class="col-xs-12">
                                                <div class="comming-soon-countdown"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- /COUNTDOWN -->
                                <div class="panel-body">
                                    <div class="form-inline">
                                        <?php
                                        $foreverwedding_sSubscribeForm = ot_get_option('coming_soon_subscribe_form');
                                        if (!empty($foreverwedding_sSubscribeForm)) :
                                            echo do_shortcode($foreverwedding_sSubscribeForm);
                                        endif;
                                        ?> 
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
<?php wp_footer(); ?>
    </body>
</html>
