<?php
/**
 * Forever Wedding - blog layout two
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.content.format
 * @since foreverwedding 1.0.0
 */
?>

<div class="col-xs-12 col-sm-8 col-md-9 foreverwedding-blog-layout-two">
    <?php
    if (is_page()):

        $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;

        $foreverwedding_blog_args = array(
            'post_type' => 'post',
            'post_status' => 'publish',
            'paged' => $paged
        );

        $foreverwedding_blog_query = new WP_Query($foreverwedding_blog_args);

        if ($foreverwedding_blog_query->have_posts()) :
            while ($foreverwedding_blog_query->have_posts()) : $foreverwedding_blog_query->the_post();
                $post_formates = get_theme_support('post-formats');
		$post_formate = $post_formates[0];
                $format = (get_post_format()) ? get_post_format() : 'standard';
		if(in_array($format, $post_formate)) {
		    get_template_part('content/format/' . $format);
		} else {
		    get_template_part('content/format/standard');
		}
            endwhile;
            foreverwedding_pagenavi($foreverwedding_blog_query);
        else :
            get_template_part('content/none');
        endif;
        wp_reset_postdata();
    else:
        if (have_posts()) :
            while (have_posts()) : the_post();
                $post_formates = get_theme_support('post-formats');
		$post_formate = $post_formates[0];
                $format = (get_post_format()) ? get_post_format() : 'standard';
		if(in_array($format, $post_formate)) {
		    get_template_part('content/format/' . $format);
		} else {
		    get_template_part('content/format/standard');
		}
            endwhile;
            foreverwedding_pagenavi();
        else :
            get_template_part('content/none');
        endif;
    endif;
    ?>
</div><!-- left-column ends here -->
<div class="col-xs-12 col-sm-4 col-md-3">
    <?php get_sidebar(); ?>
</div> <!-- sidebar ends here -->
<?php 